/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef IMAGE_H
#define IMAGE_H


class Image
{

public:
	Image(const int imageWidth, const int imageHeight);
	~Image();

	float highExposedPixels();
	float lowExposedPixels();
	void  swapRedBlueChannel();
	void  changeBlueIntensity(float intensity);
	void  changeBlueIntensity(int intensity);

	unsigned char *imageBuffer;
	int   imageSize;

private:
	unsigned char meanRGB(const unsigned char *pixel);

	int width;
	int height;
	int pixels;

};

#endif
