/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ROBOTSERVER_H
#define ROBOTSERVER_H

#define TCP_PORT 13787

// Server heartbeat period must be longer than client period
#define HEART_BEAT_PERIOD 5000
#define IMAGE_SEND_PERIOD 500

#include <QTcpServer>

const float  ROBOT_VERSION = 0.10;
const int    COMM_ID  = 1945790125;
const qint8  NO_SELECTOR         = 0;
const qint8  ROBOT_VERSION_INFO  = 1;
const qint8  COMM_ID_INFO        = 2;
const qint8  HEART_BEAT          = 3;
const qint8  ALREADY_CONNECTED	 = 4;
const qint8  SELECT_SPEED        = 10;
const qint8  SELECT_STEERING     = 11;
const qint8  SELECT_IMAGE        = 12;

class QTcpSocket;
class QTextStream;
class RobotControl;
class CameraControl;
class QTimer;

class RobotServer : public QTcpServer
{
	Q_OBJECT

public:
	RobotServer(QObject *parent = 0);

	bool  listen();
	float robotClientVersion;

private:
	QTcpSocket		*clientConnection;
	qint8			 commSelector;
	bool			 robotClientConnected;
	RobotControl	*robotControl;
	CameraControl	*cameraControl;
	QTimer			*heartBeat;
	QTimer			*imageProcessing;
	bool			 heartBeatSeen;
	bool			 tcpClientConnected;
	QTimer			*autoControlTimer;
	QTimer			*autoDriveTimer;
	
private slots:
	void startCommunication();
	void endCommunication();
	void readClientData();
	void checkHeartBeat();
	void sendImage();	
	void autoControl();
	void autoDriveDisconnectPower();
	
public slots:
	void stopRobotControl();
	
};

#endif
